<?php
/**
 * Elementor Montoya Marquee Text Widget.
 *
 * Elementor widget that inserts an rolling, marquee text into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Elementor_Montoya_Marquee_Text_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Marquee Text widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'montoya_marquee_text';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Marquee Text widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Marquee Text', 'montoya-elementor-widgets' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Marquee Text widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-animation-text';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Marquee Text widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'montoya-widgets' ];
	}

	/**
	 * Register Marquee Text widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'montoya-elementor-widgets' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'direction',
			[
				'label'        => __( 'Direction', 'montoya-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'fw',
				'options'      => array( 'fw' => __( 'Forward', 'montoya-elementor-widgets' ),
										'bw' => __( 'Backward', 'montoya-elementor-widgets' ) )
			]
		);
		
		$this->add_control(
			'header_type',
			[
				'label'        => __( 'Header Type', 'montoya-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'h1',
				'options'      => array( 'h1' => __( 'H1', 'montoya-elementor-widgets' ),
												'h2' => __( 'H2', 'montoya-elementor-widgets' ),
												'h3' => __( 'H3', 'montoya-elementor-widgets' ),
												'h4' => __( 'H4', 'montoya-elementor-widgets' ),
												'h5' => __( 'H5', 'montoya-elementor-widgets' ),
												'h6' => __( 'H6', 'montoya-elementor-widgets' )	)
			]
		);
		
		$this->add_control(
			'title_type',
			[
				'label'        => __( 'Big Title?', 'montoya-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'big-title',
				'options'      => array( 'big-title' => __( 'Yes', 'montoya-elementor-widgets' ),
										'no-big-title' => __( 'No', 'montoya-elementor-widgets' ) )
			]
		);
		
		
		$this->add_control(
			'content',
			[
				'label' => __( 'The text', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'show_label' => false,
				'default' => __( 'Marquee text here', 'montoya-elementor-widgets' ),
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render Marquee Text widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<div class="marquee-text-wrapper">';
		echo '<' . esc_attr( $settings['header_type'] ) . ' class="marquee-text no-margins ' . sanitize_html_class( $settings['title_type'] ) . ' ' . sanitize_html_class( $settings['direction'] ) . '">' . wp_kses_post( $settings['content'] ) . '</' . esc_attr( $settings['header_type'] ) . '>';
		echo '</div>';
	}

}

?>
