<?php
/**
 * Elementor Montoya Flex List Widget.
 *
 * Elementor widget that inserts a flex list of items inverting the colors on hover.
 *
 * @since 1.0.0
 */
class Elementor_Montoya_Flex_List_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Flex List widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'montoya_flex_list';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Flex List widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Flex List', 'montoya-elementor-widgets' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve flex list widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-editor-list-ol';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the flex list widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'montoya-widgets' ];
	}

	/**
	 * Register Flex List widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'montoya-elementor-widgets' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'left_column',
			[
				'label' => __( 'Left Column Text (HTML allowed)', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);
		
		$repeater->add_control(
			'center_column',
			[
				'label' => __( 'Center Column Text (HTML allowed)', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);
		
		$repeater->add_control(
			'right_column',
			[
				'label' => __( 'Right Column Text (HTML allowed)', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'rows' => 20,
			]
		);

		$this->add_control(
			'list_items',
			[
				'label' => __( 'List Items', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'left_column' => __( 'List Item #1 - Left Column', 'montoya-elementor-widgets' ),
						'center_column' => __( 'List Item #1 - Center Column', 'montoya-elementor-widgets' ),
						'right_column' => __( 'List Item #1 - Right Column', 'montoya-elementor-widgets' ),
					],
					[
						'left_column' => __( 'List Item #2 - Left Column', 'montoya-elementor-widgets' ),
						'center_column' => __( 'List Item #2 - Center Column', 'montoya-elementor-widgets' ),
						'right_column' => __( 'List Item #2 - Right Column', 'montoya-elementor-widgets' ),
					],
				]
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render List Rotator widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<ul class="flex-list-wrapper">';
		
		foreach ( $settings['list_items'] as $item ) {
			
			echo '<li class="flex-list link has-animation">';
			echo '<span class="flex-list-left">' . wp_kses_post( $item['left_column'] ) . '</span>';
			echo '<span class="flex-list-center">' . wp_kses_post( $item['center_column'] ) . '</span>';
			echo '<span class="flex-list-right">' . wp_kses_post( $item['right_column'] ) . '</span>';
			echo '</li>';
		}
		
		echo '</ul>';

	}

}

?>
