<?php
/**
 * Elementor Montoya Moving Title Widget.
 *
 * Elementor widget that inserts an rolling text on scroll
 *
 * @since 1.0.0
 */
class Elementor_Montoya_Moving_Title_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Moving Title widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'montoya_moving_title';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Moving Title widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Moving Title', 'montoya-elementor-widgets' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Moving Title widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-text-area';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Moving Title widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'montoya-widgets' ];
	}

	/**
	 * Register Moving Title widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'montoya-elementor-widgets' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'direction',
			[
				'label'       	=> __( 'Moving Direction', 'montoya-elementor-widgets' ),
				'type'        	=> \Elementor\Controls_Manager::SELECT,
				'default'     	=> 'title-moving-forward',
				'options'     	=> array( 'title-moving-forward' => __( 'Forward', 'montoya-elementor-widgets' ),
										'title-moving-backward' => __( 'Backward', 'montoya-elementor-widgets' ) )
			]
		);
		
		$this->add_control(
			'header_type',
			[
				'label'        => __( 'Header Type', 'montoya-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'h1',
				'options'      => array( 'h1' => __( 'H1', 'montoya-elementor-widgets' ),
												'h2' => __( 'H2', 'montoya-elementor-widgets' ),
												'h3' => __( 'H3', 'montoya-elementor-widgets' ),
												'h4' => __( 'H4', 'montoya-elementor-widgets' ),
												'h5' => __( 'H5', 'montoya-elementor-widgets' ),
												'h6' => __( 'H6', 'montoya-elementor-widgets' )	)
			]
		);
		
		$this->add_control(
			'title_type',
			[
				'label'        => __( 'Big Title?', 'montoya-elementor-widgets' ),
				'type'         => \Elementor\Controls_Manager::SELECT,
				'default'      => 'big-title',
				'options'      => array( 'big-title' => __( 'Yes', 'montoya-elementor-widgets' ),
										'no-big-title' => __( 'No', 'montoya-elementor-widgets' ) )
			]
		);

		$this->add_control(
			'content',
			[
				'label' => __( 'The text', 'montoya-elementor-widgets' ),
				'type' => \Elementor\Controls_Manager::CODE,
				'language' => 'html',
				'show_label' => false,
				'default' => __( 'Moving title here', 'montoya-elementor-widgets' ),
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render Moving Title widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		echo '<div class="title-moving-outer">';
		echo '<' . esc_attr( $settings['header_type'] ) . ' class="' . sanitize_html_class( $settings['title_type'] ) . ' ' . esc_attr( $settings['direction'] ) . '">' . wp_kses_post( $settings['content'] ) . '</' . esc_attr( $settings['header_type'] ) . '>';
		echo '</div>';
	}

}

?>
